<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

namespace Amasty\PromoGraphql\Test\GraphQl;

use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;
use Magento\GraphQl\Quote\GetMaskedQuoteIdByReservedOrderId;

class AmPromoGetAvailableFreeGiftsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amPromoGetAvailableFreeGifts';

    /**
     * @var GetMaskedQuoteIdByReservedOrderId
     */
    private $getMaskedQuoteIdByReservedOrderId;

    protected function setUp(): void
    {
        parent::setUp();

        $objectManager = Bootstrap::getObjectManager();
        $this->getMaskedQuoteIdByReservedOrderId = $objectManager->get(GetMaskedQuoteIdByReservedOrderId::class);
    }

    /**
     * @group amasty_promo
     *
     * @magentoConfigFixture admin_store ampromo/general/auto_add 0
     *
     * @magentoApiDataFixture Magento/GraphQl/Quote/_files/guest/create_empty_cart.php
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/add_simple_product.php
     *
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/promo_rule_eachn.php
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/promo_rule_products.php
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/promo_rule_same.php
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/promo_rule_spent.php
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/promo_rule_whole_cart.php
     */
    public function testAmPromoGetAvailableFreeGifts()
    {
        $maskedQuote = $this->getMaskedQuoteIdByReservedOrderId->execute('test_quote');

        $fields = [
            'available_gifts_qty' => 15,
            'promo_items' => [
                [
                    'available_qty' => 2,
                    'price' => 0,
                    'sku' => 'simple_product'
                ],
                [
                    'available_qty' => 2,
                    'price' => 0,
                    'sku' => 'virtual_5'
                ],
                [
                    'available_qty' => 2,
                    'price' => 0,
                    'sku' => 'simple_20'
                ],
                [
                    'available_qty' => 3,
                    'price' => 10,
                    'sku' => 'virtual_product'
                ],
                [
                    'available_qty' => 3,
                    'price' => 20,
                    'sku' => 'simple-product-tax-none'
                ],
                [
                    'available_qty' => 3,
                    'price' => 10,
                    'sku' => 'simple_10'
                ]
            ]
        ];

        $query = $this->getQuery($maskedQuote);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY], $fields);
    }

    /**
     * @param $cartId
     * @return string
     */
    private function getQuery($cartId): string
    {
        $query = <<<QUERY
query {
    amPromoGetAvailableFreeGifts(cartId:$cartId) {
        available_gifts_qty
        promo_items {
            available_qty
            price
            sku
        }
    }
}
QUERY;
        return $query;
    }
}
