<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

namespace Amasty\PromoGraphql\Test\GraphQl;

use Magento\GraphQl\Quote\GetMaskedQuoteIdByReservedOrderId;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmPromoAddFreeGiftsToCartTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amPromoAddFreeGiftsToCart';

    /**
     * @var GetMaskedQuoteIdByReservedOrderId
     */
    private $getMaskedQuoteIdByReservedOrderId;

    protected function setUp(): void
    {
        parent::setUp();

        $objectManager = Bootstrap::getObjectManager();
        $this->getMaskedQuoteIdByReservedOrderId = $objectManager->get(GetMaskedQuoteIdByReservedOrderId::class);
    }

    /**
     * @group amasty_promo
     *
     * @magentoApiDataFixture Magento/GraphQl/Quote/_files/guest/create_empty_cart.php
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/add_simple_product.php
     *
     * @magentoApiDataFixture Amasty_PromoGraphql::Test/GraphQl/_files/promo_rule_whole_cart.php
     */
    public function testAmPromoAddFreeGiftsToCart()
    {
        $maskedQuote = $this->getMaskedQuoteIdByReservedOrderId->execute('test_quote');

        $variables = [
            'cartId' => $maskedQuote,
            'quantity' => 2,
            'sku' => 'simple_10'
        ];

        $fields = [
            'cart' => [
                'items' => [
                    [
                        'product' => [
                            'sku' => 'simple_20'
                        ],
                        'quantity' => 4
                    ],
                    [
                        'product' => [
                            'sku' => 'simple_10'
                        ],
                        'quantity' => 2
                    ]
                ],
            ]
        ];

        $query = $this->getQuery();
        $response = $this->graphQlMutation($query, $variables);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY], $fields);
        $this->assertEmpty($response[self::MAIN_QUERY_KEY]['user_errors']);
    }

    /**
     * @return string
     */
    private function getQuery(): string
    {
        return <<<'MUTATION'
mutation SaveAdditionalFields(
    $cartId: String!,
    $quantity: Float!,
    $sku: String!
  ) {
        amPromoAddFreeGiftsToCart(
            cartId:$cartId,
            promoItems: {
                quantity:$quantity,
                sku:$sku
            }
        ) {
            cart {
                items {
                    product {
                        sku
                    }
                    quantity
                }
            }
            user_errors
        }
    }
MUTATION;
    }
}
