<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

namespace Amasty\PromoGraphql\Model\Resolver;

use Amasty\Promo\Helper\Data;
use Amasty\PromoGraphql\Model\PromoItemsConverter;
use Amasty\PromoGraphql\Model\QuoteProcessor;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class AvailableGifts implements ResolverInterface
{
    /**
     * @var Data
     */
    private $dataHelper;

    /**
     * @var PromoItemsConverter
     */
    private $itemsOutput;

    /**
     * @var QuoteProcessor
     */
    private $quoteProcessor;

    public function __construct(
        Data $dataHelper,
        QuoteProcessor $quoteProcessor,
        PromoItemsConverter $itemsOutput
    ) {
        $this->dataHelper = $dataHelper;
        $this->quoteProcessor = $quoteProcessor;
        $this->itemsOutput = $itemsOutput;
    }

    /**
     * @param ContextInterface $context
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null): array
    {
        $quote = $this->quoteProcessor->process($args['cartId'], $context);

        $data = $this->dataHelper->getPromoItemsDataArray($quote);
        $itemsData = $this->itemsOutput->getItemsOutputData($data['promo_sku']);

        return [
            'available_gifts_qty' => $data['common_qty'],
            'promo_items' => $itemsData
        ];
    }
}
