<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

namespace Amasty\PromoGraphql\Model;

use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Quote\Model\Quote;
use Magento\QuoteGraphQl\Model\Cart\GetCartForUser;

class QuoteProcessor
{
    /**
     * @var GetCartForUser
     */
    private $getCartForUser;

    public function __construct(
        GetCartForUser $getCartForUser
    ) {
        $this->getCartForUser = $getCartForUser;
    }

    public function process(string $maskedCartId, ContextInterface $context): Quote
    {
        $currentUserId = $context->getUserId();
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();
        $quote = $this->getCartForUser->execute($maskedCartId, $currentUserId, $storeId);

        // To update our storage we need to recollect totals.
        // @see Amasty\Promo\Model\ItemRegistry\PromoItemRegistry::$storage
        $quote->collectTotals();

        return $quote;
    }
}
