<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

namespace Amasty\PromoGraphql\Model;

use Amasty\Promo\Model\DiscountCalculator;
use Magento\Catalog\Api\ProductRepositoryInterface;

class PromoItemsConverter
{
    /**
     * @var DiscountCalculator
     */
    private $discountCalculator;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    public function __construct(
        ProductRepositoryInterface $productRepository,
        DiscountCalculator $discountCalculator
    ) {
        $this->discountCalculator = $discountCalculator;
        $this->productRepository = $productRepository;
    }

    public function getItemsOutputData(array $promoData): array
    {
        $result = [];

        foreach ($promoData as $name => $data) {
            $itemPrice = (float)$this->productRepository->get($name)->getFinalPrice();

            $discountAmount = $this->discountCalculator->getBaseDiscount(
                (string)$data['discount']['discount_item'],
                $itemPrice
            );

            $itemPrice = max(0, ($itemPrice - $discountAmount));
            $result[] = [
                'sku' => $name,
                'available_qty' => $data['available_qty'],
                'price' => $itemPrice
            ];
        }

        return $result;
    }
}
