/**
 * Fullscreen model
 */

define([
    'ko',
    'splideSlider',
    'splideVideo'
], function (ko, Splide) {
    'use strict';

    /**
     * Check if the device is touchable
     *
     * @return {bool}
     */
    var _isTouchDevice = function () {
        return ('ontouchstart' in window) ||
            (navigator.maxTouchPoints > 0) ||
            (navigator.msMaxTouchPoints > 0);
    };

    return {
        splideSlider: Splide,
        splideVideo: window.splide.Extensions.Video,
        isTouchDevice: _isTouchDevice,
        isFsActive: ko.observable(false),
        isFsProcess: ko.observable(false)
    };
});
