/**
 * Custom gallery -> video connector
 * Main actions for video comes from the splide video extension
 */

define([
    'underscore'
], function (_) {
    'use strict';

    var YOUTUBE = 'youtube',
        YOUTUBE2 = 'youtu.be',
        VIMEO = 'vimeo',
        onlinePlayers = [YOUTUBE, YOUTUBE2, VIMEO],

        /**
         * @private
         *
         * @param {object} item
         *
         * @return {string} - 'vimeo' || 'youtube'
         */
        _getPlayer = function (item) {
            var player = _.filter(onlinePlayers, function (playerType) {
                return item.videoUrl.match(playerType);
            });

            return player[0] === VIMEO ? VIMEO : YOUTUBE;
        };

    return {
        /**
         * Add video player type (vimeo or youtube) to the gallery data
         * for items with the 'video' type
         *
         * @param {object} data
         *
         * @return {object}
         */
        modifyDataList: function (data) {
            var modifiedData = data;

            _.each(modifiedData, function (item) {
                item.player = '';

                if (item.type === 'video') {
                    item.player = _getPlayer(item);
                }
            });

            return modifiedData;
        }
    };
});
