<?php

declare(strict_types=1);

namespace Amasty\Gallery\Observer;

use Amasty\Gallery\Model\Config\Source\ImageGallery;
use Amasty\Gallery\Model\ConfigProvider;
use Amasty\JetTheme\Model\StoreThemeMapper;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\View\LayoutInterface;

class ApplyGalleryLayout implements ObserverInterface
{
    const GALLERY_LAYOUT_UPDATE = 'catalog_product_view_amgallery';
    const CATALOG_PRODUCT_VIEW_ACTION = 'catalog_product_view';

    /**
     * @var string[]
     */
    private $actionsToUpdate = [
        'catalog_product_view',
        'amasty_jettheme_ajax_quickView',
        'amasty_jettheme_ajax_addToCart',
        'amasty_jettheme_ajax_addToCompare',
        'amasty_jettheme_ajax_addToWishlist'
    ];

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var StoreThemeMapper
     */
    private $storeThemeMapper;

    public function __construct(
        ConfigProvider $configProvider,
        StoreThemeMapper $storeThemeMapper
    ) {
        $this->configProvider = $configProvider;
        $this->storeThemeMapper = $storeThemeMapper;
    }

    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer): void
    {
        /** @var LayoutInterface|null $layout **/
        $layout = $observer->getEvent()->getLayout();
        $fullActionName = $observer->getEvent()->getFullActionName();

        if (null === $layout
            || $this->configProvider->getImageGalleryType() !== ImageGallery::SPLIDE
            || !in_array($fullActionName, $this->actionsToUpdate)
            || !$this->storeThemeMapper->isCurrentThemeJetTheme()) {
            return;
        }

        $layoutUpdate = $layout->getUpdate();
        $layoutUpdate->addHandle(self::GALLERY_LAYOUT_UPDATE);
    }
}
