<?php

declare(strict_types=1);

namespace Amasty\Gallery\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * xpath prefix of module (section)
     */
    protected $pathPrefix = 'amasty_gallery/';

    const THUMBNAIL_GALLERY_BLOCK = 'thumbnails_gallery/';
    const MAGNIFIER_BLOCK = 'magnifier/';
    const FULLSCREEN_MODE_BLOCK = 'fullscreen_mode/';

    const IMAGE_GALLERY = 'image_gallery';
    const SHOW_IMAGE_GALLERY_THUMBNAILS = 'show_image_gallery_thumbnails';
    const THUMBNAIL_POSITION = 'thumbnail_position';
    const MAIN_IMAGE_CHANGE = 'main_image_change';
    const ENABLE_LAZY_LOAD = 'enable_lazy_load';

    const ENABLE_ZOOM = 'enable_zoom';
    const ACTIVATE_ZOOM = 'activate_zoom';

    const ENABLE_FULLSCREEN_MODE = 'enable_fullscreen_mode';
    const ENABLE_ANIMATION = 'enable_animation';
    const SHOW_THUMBNAILS_IN_FULLSCREEN_MODE = 'show_thumbnails_in_fullscreen_mode';
    const FULLSCREEN_THUMBNAILS_POSITION = 'fullscreen_thumbnails_position';
    const FULLSCREEN_MAIN_IMAGE_CHANGE = 'fullscreen_main_image_change';
    const ENABLE_MOUSE_SCROLL_ACTION = 'enable_mouse_scroll_action';
    const FULLSCREEN_BACKGROUND_TYPE = 'fullscreen_background_type';
    const FULLSCREEN_BACKGROUND_COLOR = 'fullscreen_background_color';
    const FULLSCREEN_BLUR_BACKGROUND = 'fullscreen_blur_background';
    const FULLSCREEN_OPACITY_PERCENTAGE = 'fullscreen_opacity_percentage';

    /**
     * @return string|null
     */
    public function getImageGalleryType(): ?string
    {
        return $this->getValue(self::THUMBNAIL_GALLERY_BLOCK . self::IMAGE_GALLERY);
    }

    /**
     * @return bool
     */
    public function isShowImageGalleryThumbnails(): bool
    {
        return $this->isSetFlag(self::THUMBNAIL_GALLERY_BLOCK . self::SHOW_IMAGE_GALLERY_THUMBNAILS);
    }

    /**
     * @return string|null
     */
    public function getThumbnailPosition(): ?string
    {
        return $this->getValue(self::THUMBNAIL_GALLERY_BLOCK . self::THUMBNAIL_POSITION);
    }

    /**
     * @return string|null
     */
    public function getMainImageChange(): ?string
    {
        return $this->getValue(self::THUMBNAIL_GALLERY_BLOCK . self::MAIN_IMAGE_CHANGE);
    }

    /**
     * @return bool
     */
    public function isLazyLoadEnabled(): bool
    {
        return $this->isSetFlag(self::THUMBNAIL_GALLERY_BLOCK . self::ENABLE_LAZY_LOAD);
    }

    /**
     * @return bool
     */
    public function isZoomEnabled(): bool
    {
        return $this->isSetFlag(self::MAGNIFIER_BLOCK . self::ENABLE_ZOOM);
    }

    /**
     * @return string|null
     */
    public function getActivateZoom(): ?string
    {
        return $this->getValue(self::MAGNIFIER_BLOCK . self::ACTIVATE_ZOOM);
    }

    /**
     * @return bool
     */
    public function isFullscreenModeEnabled(): bool
    {
        return $this->isSetFlag(self::FULLSCREEN_MODE_BLOCK . self::ENABLE_FULLSCREEN_MODE);
    }

    /**
     * @return bool
     */
    public function isAnimationEnabled(): bool
    {
        return $this->isSetFlag(self::FULLSCREEN_MODE_BLOCK . self::ENABLE_ANIMATION);
    }

    /**
     * @return bool
     */
    public function isFullscreenShowThumbnails(): bool
    {
        return $this->isSetFlag(self::FULLSCREEN_MODE_BLOCK . self::SHOW_THUMBNAILS_IN_FULLSCREEN_MODE);
    }

    /**
     * @return string|null
     */
    public function getFullscreenThumbnailsPosition(): ?string
    {
        return $this->getValue(self::FULLSCREEN_MODE_BLOCK . self::FULLSCREEN_THUMBNAILS_POSITION);
    }

    /**
     * @return string|null
     */
    public function getFullscreenMainImageChange(): ?string
    {
        return $this->getValue(self::FULLSCREEN_MODE_BLOCK . self::FULLSCREEN_MAIN_IMAGE_CHANGE);
    }

    /**
     * @return bool
     */
    public function isMouseScrollActionEnabled(): bool
    {
        return $this->isSetFlag(self::FULLSCREEN_MODE_BLOCK . self::ENABLE_MOUSE_SCROLL_ACTION);
    }

    /**
     * @return string|null
     */
    public function getFullScreenBackgroundType(): ?string
    {
        return $this->getValue(self::FULLSCREEN_MODE_BLOCK . self::FULLSCREEN_BACKGROUND_TYPE);
    }

    /**
     * @return string|null
     */
    public function getFullscreenBackgroundColor(): ?string
    {
        return $this->getValue(self::FULLSCREEN_MODE_BLOCK . self::FULLSCREEN_BACKGROUND_COLOR);
    }

    /**
     * @return string|null
     */
    public function isFullscreenBackgroundBlur(): ?string
    {
        return $this->getValue(self::FULLSCREEN_MODE_BLOCK . self::FULLSCREEN_BLUR_BACKGROUND);
    }

    /**
     * @return int
     */
    public function getFullScreenOpacityPercentage(): int
    {
        return (int)$this->getValue(self::FULLSCREEN_MODE_BLOCK . self::FULLSCREEN_OPACITY_PERCENTAGE);
    }
}
