<?php

declare(strict_types=1);

namespace Amasty\Gallery\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class FullScreenThumbnailPosition implements OptionSourceInterface
{
    const BOTTOM = 'bottom';
    const LEFT = 'left';
    const RIGHT = 'right';

    public function toOptionArray(): array
    {
        return [
            ['label' => __('Bottom'), 'value' => self::BOTTOM],
            ['label' => __('Left'), 'value' => self::LEFT],
            ['label' => __('Right'), 'value' => self::RIGHT],
        ];
    }
}
