<?php

declare(strict_types=1);

namespace Amasty\Gallery\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class FullScreenBackgroundType implements OptionSourceInterface
{
    const FULL_OPACITY = 'full_opacity';
    const COLOR = 'color';
    const ADAPTIVE_BACKGROUND = 'adaptive_background';

    public function toOptionArray(): array
    {
        return [
            ['label' => __('Full opacity'), 'value' => self::FULL_OPACITY],
            ['label' => __('Color'), 'value' => self::COLOR],
            ['label' => __('Adaptive background'), 'value' => self::ADAPTIVE_BACKGROUND],
        ];
    }
}
