<?php

declare(strict_types=1);

namespace Amasty\Gallery\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class ActivateZoom implements OptionSourceInterface
{
    const ON_CLICK = 'click';
    const ON_HOVER = 'hover';

    public function toOptionArray(): array
    {
        return [
            ['label' => __('On Click'), 'value' => self::ON_CLICK],
            ['label' => __('On Hover'), 'value' => self::ON_HOVER],
        ];
    }
}
