<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\ViewModel;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class PageId implements ArgumentInterface
{
    /**
     * @var RequestInterface
     */
    private RequestInterface $request;

    public function __construct(
        RequestInterface $request
    ) {
        $this->request = $request;
    }

    public function getPageId(): ?string
    {
        return $this->request->getParam('id');
    }
}
