<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\ViewModel;

use Amasty\AjaxCartHyva\Model\CartConfigProvider;
use Magento\Catalog\Block\Product\AbstractProduct;
use Magento\Catalog\Model\ResourceModel\Product\Collection;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\LayoutInterface;

class ItemsSlider implements ArgumentInterface
{
    /**
     * @var LayoutInterface
     */
    private LayoutInterface $layout;

    /**
     * @var CartConfigProvider
     */
    private CartConfigProvider $configProvider;

    /**
     * @var string
     */
    private string $listItemTemplate;

    /**
     * @var string
     */
    private string $productSliderTemplate;

    /**
     * @var string
     */
    private string $productSliderContainer;

    /**
     * @var Template|null
     */
    private ?Template $sliderBlock = null;

    public function __construct(
        LayoutInterface $layout,
        CartConfigProvider $configProvider,
        string $listItemTemplate,
        string $productSliderTemplate,
        string $productSliderContainer
    ) {
        $this->layout = $layout;
        $this->configProvider = $configProvider;
        $this->listItemTemplate = $listItemTemplate;
        $this->productSliderTemplate = $productSliderTemplate;
        $this->productSliderContainer = $productSliderContainer;
    }

    public function getSliderBlock(): Template
    {
        if (!$this->sliderBlock) {
            /*
             * Due to Ajax Cart render only block, not whole page,
             * we should add some data to the layout from hyva_product_slider update handler
             */
            $this->layout->getUpdate()->addUpdate('hyva_product_slider');
            $this->layout->createBlock(
                AbstractProduct::class,
                'product_list_item'
            )->setTemplate($this->listItemTemplate);

            $this->sliderBlock = $this->layout->createBlock(
                Template::class,
                'amcart.related_crossel.products'
            )->setTemplate($this->productSliderTemplate);

            $this->sliderBlock->setContainerTemplate($this->productSliderContainer);
            $this->sliderBlock->setPageSize($this->configProvider->getProductsQtyLimit());
        }

        return $this->sliderBlock;
    }

    public function setItems(Collection $collection): self
    {
        $ids = $collection->getAllIds();
        $this->getSliderBlock()->setAdditionalFilters([
            'id-filter' => [
                'field' => 'entity_id',
                'value' => $ids,
                'conditionType' => 'in'
            ]
        ]);

        return $this;
    }

    public function render(): string
    {
        return $this->getSliderBlock()->toHtml();
    }
}
