<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Amasty\AjaxCartHyva\Model\CartConfigProvider;

class CartSettings implements ArgumentInterface
{
    /**
     * @var CartConfigProvider
     */
    private CartConfigProvider $configProvider;

    public function __construct(
        CartConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    public function isCompareWithAjax(): bool
    {
        return $this->configProvider->isCompareWithAjax();
    }

    public function isWishlistWithAjax(): bool
    {
        return $this->configProvider->isWishlistWithAjax();
    }

    public function isQtyInstantChange(): bool
    {
        return $this->configProvider->isQtyInstantChange();
    }

    public function isFlyEffectEnabled(): bool
    {
        return $this->configProvider->isFlyEffectEnabled();
    }

    public function isShowQtyProduct(): bool
    {
        return $this->configProvider->isShowQtyProduct();
    }

    public function getBackgroundColor(): string
    {
        return $this->configProvider->getBackgroundColor();
    }

    public function getProductNameColor(): string
    {
        return $this->configProvider->getProductNameColor();
    }

    public function getTextColor(): string
    {
        return $this->configProvider->getTextColor();
    }

    public function getButtonTextColor(): string
    {
        return $this->configProvider->getButtonTextColor();
    }

    public function getContinueButtonColor(): string
    {
        return $this->configProvider->getContinueButtonColor();
    }

    public function getViewCartButtonColor(): string
    {
        return $this->configProvider->getViewCartButtonColor();
    }
}
