<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Plugin\Cart\Controller\Cart\Add;

use Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse as CartAddResponseAdapter;
use Amasty\Cart\Controller\Cart\Add as CartAddController;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\App\Response\HttpInterface;

class ResponseAdapter
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @var CartAddResponseAdapter
     */
    private CartAddResponseAdapter $cartAddResponseAdapter;

    public function __construct(
        CurrentTheme $currentTheme,
        CartAddResponseAdapter $cartAddResponseAdapter
    ) {
        $this->currentTheme = $currentTheme;
        $this->cartAddResponseAdapter = $cartAddResponseAdapter;
    }

    public function afterExecute(CartAddController $subject, HttpInterface $result): HttpInterface
    {
        return $this->currentTheme->isHyva()
            ? $this->cartAddResponseAdapter->execute($result)
            : $result;
    }
}
