<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Plugin\Cart\Controller\Cart\Add;

use Amasty\AjaxCartHyva\Model\IsHyvaEnabled;
use Amasty\Cart\Controller\Cart\Add as AddController;
use Amasty\Cart\Model\ConfigProvider;
use Magento\Catalog\Model\Product;
use Magento\Framework\View\Result\Page;

class ReplaceOptionsHtml
{
    /**
     * @var IsHyvaEnabled
     */
    private $isHyvaEnabled;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var string[]
     */
    private $blockNames;

    public function __construct(IsHyvaEnabled $isHyvaEnabled, ConfigProvider $configProvider, array $blockNames = [])
    {
        $this->isHyvaEnabled = $isHyvaEnabled;
        $this->configProvider = $configProvider;
        $this->blockNames = $blockNames;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundGetOptionsHtml(
        AddController $subject,
        callable $proceed,
        Page $page,
        Product $product,
        ?string $submitRoute
    ): string {
        if (!$this->isHyvaEnabled->execute() || $this->configProvider->isMiniPage()) {
            return $proceed($page, $product, $submitRoute);
        }

        $html = '';
        foreach ($this->blockNames as $blockName) {
            $block = $page->getLayout()->getBlock($blockName);
            if ($block) {
                $block->setProduct($product);
                if ($submitRoute) {
                    $block->setData('submit_route_data', [
                        'route' => $submitRoute
                    ]);
                }
                $html .= $block->toHtml();
            }
        }

        return $html;
    }
}
