<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Plugin\Cart\Controller\Cart\Add;

use Amasty\AjaxCartHyva\Model\IsHyvaEnabled;
use Amasty\Cart\Controller\Cart\Add as AddController;
use Amasty\Cart\Model\ConfigProvider;

class ModifyOptionsWrap
{
    /**
     * @var IsHyvaEnabled
     */
    private $isHyvaEnabled;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(IsHyvaEnabled $isHyvaEnabled, ConfigProvider $configProvider)
    {
        $this->isHyvaEnabled = $isHyvaEnabled;
        $this->configProvider = $configProvider;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundWrapOptionsHtml(
        AddController $subject,
        callable $proceed,
        string $optionsHtml,
        string $contentClass,
        string $title,
        string $errors
    ): string {
        if (!$this->isHyvaEnabled->execute() || $this->configProvider->isMiniPage()) {
            return $proceed($optionsHtml, $contentClass, $title, $errors);
        }

        return $optionsHtml;
    }
}
