<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Plugin\Cart\Controller\Cart\Add;

use Amasty\AjaxCartHyva\Model\IsHyvaEnabled;
use Amasty\Cart\Controller\Cart\Add as AddController;
use Magento\Bundle\Model\Product\Type as BundleType;
use Magento\Catalog\Model\Product;
use Magento\Framework\View\Result\Page;

class AddBundleOptions
{
    private const BUNDLE_OPTIONS_BLOCK_NAME = 'product.info.bundle.options';

    /**
     * @var IsHyvaEnabled
     */
    private $isHyvaEnabled;

    public function __construct(IsHyvaEnabled $isHyvaEnabled)
    {
        $this->isHyvaEnabled = $isHyvaEnabled;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetOptionsHtml(
        AddController $subject,
        string $result,
        Page $page,
        Product $product,
        ?string $submitRoute
    ): string {
        if ($this->isHyvaEnabled->execute() && $product->getTypeId() === BundleType::TYPE_CODE) {
            $block = $page->getLayout()->getBlock(self::BUNDLE_OPTIONS_BLOCK_NAME);
            if ($block) {
                $block->setProduct($product);
                if ($submitRoute) {
                    $block->setData('submit_route_data', [
                        'route' => $submitRoute
                    ]);
                }
                $result .= $block->toHtml();
            }
        }

        return $result;
    }
}
