<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Plugin\Cart\Block\Product;

use Amasty\AjaxCartHyva\Model\IsHyvaEnabled;
use Magento\Framework\View\Element\Template;

class ChangeTemplate
{
    /**
     * @var IsHyvaEnabled
     */
    private $isHyvaEnabled;

    public function __construct(IsHyvaEnabled $isHyvaEnabled)
    {
        $this->isHyvaEnabled = $isHyvaEnabled;
    }

    /**
     * @param Template $subject
     * @param string $result
     * @return string
     */
    public function afterGetTemplate(Template $subject, string $result): string
    {
        if ($this->isHyvaEnabled->execute()) {
            return str_replace('Amasty_Cart::', 'Amasty_AjaxCartHyva::', (string) $result);
        }

        return $result;
    }
}
