<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Observer;

use Amasty\AjaxCartHyva\Model\IsHyvaEnabled;
use Magento\Framework\Event\Observer as Event;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\View\Element\BlockFactory;
use Magento\Framework\View\Element\Template;

class ReplaceSimplePage implements ObserverInterface
{
    /**
     * @var IsHyvaEnabled
     */
    private $isHyvaEnabled;

    /**
     * @var BlockFactory
     */
    private $blockFactory;

    public function __construct(IsHyvaEnabled $isHyvaEnabled, BlockFactory $blockFactory)
    {
        $this->isHyvaEnabled = $isHyvaEnabled;
        $this->blockFactory = $blockFactory;
    }

    /**
     * @param Event $event
     * @return void
     */
    public function execute(Event $event)
    {
        if (!$this->isHyvaEnabled->execute()) {
            return;
        }

        $resultObject = $event->getEvent()->getData('result');
        if ($resultObject) {
            $result = $resultObject->getData('result');

            if (empty($result['is_minipage'])) {
                $block = $this->blockFactory->createBlock(
                    Template::class,
                    ['data' => [
                        'template' => 'Amasty_AjaxCartHyva::product/simple_page.phtml',
                        'product' => $event->getEvent()->getData('product'),
                        'options_html' => $result['message']
                    ]]
                );

                $result['message'] = $block->toHtml();
                $resultObject->setData('result', $result);
            }
        }
    }
}
