<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class CartConfigProvider extends ConfigProviderAbstract
{
    public const COMPARE = 'general/compare';
    public const WISHLIST = 'general/wishlist';
    public const TYPE_LOADING = 'general/type_loading';
    public const SHOW_QTY_PRODUCT = 'general/show_qty_product';
    public const SELLING_PRODUCTS_QTY_LIMIT = 'selling/products_qty_limit';
    public const IS_QTY_INSTANT_CHANGE = 'dialog_popup/autosubmit';
    public const CONFIRM_POPUP_TIME = 'confirm_popup/time';
    public const VISUAL_BACKGROUND = 'visual/background';
    public const VISUAL_PRODUCT_NAME = 'visual/product_name';
    public const VISUAL_TEXT = 'visual/text';
    public const VISUAL_BUTTON_TEXT = 'visual/button_text';
    public const VISUAL_LEFT_BUTTON = 'visual/left_button';
    public const VISUAL_RIGHT_BUTTON = 'visual/right_button';

    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_cart/';

    public function isCompareWithAjax(?string $scopeCode = null): bool
    {
        return (bool)$this->getValue(self::COMPARE, $scopeCode);
    }

    public function isWishlistWithAjax(?string $scopeCode = null): bool
    {
        return (bool)$this->getValue(self::WISHLIST, $scopeCode);
    }

    public function isQtyInstantChange(?string $scopeCode = null): bool
    {
        return (bool)$this->getValue(self::IS_QTY_INSTANT_CHANGE, $scopeCode);
    }

    public function getProductsQtyLimit(?string $scopeCode = null): int
    {
        return (int)($this->getValue(self::SELLING_PRODUCTS_QTY_LIMIT, $scopeCode) ?: 2);
    }

    public function getConfirmPopupTime(?string $scopeCode = null): int
    {
        return (int)$this->getValue(self::CONFIRM_POPUP_TIME, $scopeCode);
    }

    public function isFlyEffectEnabled(?string $scopeCode = null): bool
    {
        return (bool)$this->getValue(self::TYPE_LOADING, $scopeCode);
    }

    public function isShowQtyProduct(?string $scopeCode = null): bool
    {
        return (bool)$this->getValue(self::SHOW_QTY_PRODUCT, $scopeCode);
    }

    public function getBackgroundColor(?string $scopeCode = null): string
    {
        return $this->getColorSetting(self::VISUAL_BACKGROUND, $scopeCode);
    }

    public function getProductNameColor(?string $scopeCode = null): string
    {
        return $this->getColorSetting(self::VISUAL_PRODUCT_NAME, $scopeCode);
    }

    public function getTextColor(?string $scopeCode = null): string
    {
        return $this->getColorSetting(self::VISUAL_TEXT, $scopeCode);
    }

    public function getButtonTextColor(?string $scopeCode = null): string
    {
        return $this->getColorSetting(self::VISUAL_BUTTON_TEXT, $scopeCode);
    }

    public function getContinueButtonColor(?string $scopeCode = null): string
    {
        return $this->getColorSetting(self::VISUAL_LEFT_BUTTON, $scopeCode);
    }

    public function getViewCartButtonColor(?string $scopeCode = null): string
    {
        return $this->getColorSetting(self::VISUAL_RIGHT_BUTTON, $scopeCode);
    }

    private function getColorSetting(string $path, ?string $scopeCode = null): string
    {
        return '#' . ltrim((string)$this->getValue($path, $scopeCode), '#');
    }
}
