<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse;

use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;
use Amasty\AjaxCartHyva\Model\CartConfigProvider;

class TimerConverter implements ResponseConverterInterface
{
    public const TIMER = 'timer';

    /**
     * @var CartConfigProvider
     */
    private CartConfigProvider $configProvider;

    public function __construct(
        CartConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    public function convert(array $response): array
    {
        if (isset($response[self::TIMER])) {
            // We have markup for timer in the original response.
            $response[self::TIMER] = $this->configProvider->getConfirmPopupTime();
        }

        return $response;
    }
}
