<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse;

use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;

class RelatedConverter implements ResponseConverterInterface
{
    public const RELATED = 'related';
    public const RELATED_CONTAINER = 'amcart-related-container';

    public function convert(array $response): array
    {
        if (isset($response[self::RELATED])) {
            $response[self::RELATED] = sprintf(
                '<div id="%s" class="%s">%s</div>',
                self::RELATED_CONTAINER,
                self::RELATED_CONTAINER,
                $response[self::RELATED]
            );
        }

        return $response;
    }
}
