<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse;

use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;

class PopupActionConverter implements ResponseConverterInterface
{
    public const OPEN_CONFIRMATION_POPUP = 'amcart-open-confirmation-popup';
    public const OPEN_DIALOG_POPUP = 'amcart-open-dialog-popup';
    public const OPEN_MINICART = 'toggle-cart';
    public const POPUP_ACTION_PARAM = 'popup_action';
    public const IS_ADD_TO_CART = 'is_add_to_cart';
    public const IS_MINIPAGE = 'is_minipage';
    public const MESSAGE = 'message';

    public function convert(array $response): array
    {
        if (!isset($response[self::IS_ADD_TO_CART])) {
            return $response;
        }

        $popupAction = $this->getPopupAction($response);

        if ($popupAction !== null) {
            unset($response[self::IS_ADD_TO_CART], $response[self::IS_MINIPAGE]);
            $response[self::POPUP_ACTION_PARAM] = $popupAction;
        }

        return $response;
    }

    private function getPopupAction($response): ?string
    {
        if ($this->isAddToCart($response) === 1) {
            if ($this->isContainMessage($response)) {
                return self::OPEN_CONFIRMATION_POPUP;
            }

            return self::OPEN_MINICART;
        }

        if ($this->isMiniPage($response) !== null) {
            return self::OPEN_DIALOG_POPUP;
        }

        return null;
    }

    private function isAddToCart(array $response): int
    {
        return (int)$response[self::IS_ADD_TO_CART];
    }

    private function isMiniPage(array $response): ?bool
    {
        return isset($response[self::IS_MINIPAGE]) ? (bool)$response[self::IS_MINIPAGE] : null;
    }

    private function isContainMessage(array $response): bool
    {
        return isset($response[self::MESSAGE]);
    }
}
