<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse;

use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;

/**
 * Should be called after PopupActionConverter
 */
class MessageConverter implements ResponseConverterInterface
{
    public const MESSAGE = 'message';
    public const CONTENT_ID = 'amcart-confirmation-popup-content';

    public function convert(array $response): array
    {
        $message = $response[self::MESSAGE] ?? null;
        $popupAction = $response[PopupActionConverter::POPUP_ACTION_PARAM] ?? null;

        if ($message && $popupAction === PopupActionConverter::OPEN_CONFIRMATION_POPUP) {
            $response[self::MESSAGE] = sprintf(
                '<div id="%s" class="%s">%s</div>',
                self::CONTENT_ID,
                self::CONTENT_ID,
                $message
            );
        }

        return $response;
    }
}
