<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse;

use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;

class CheckoutActionConverter implements ResponseConverterInterface
{
    public const CHECKOUT = 'checkout';

    public function convert(array $response): array
    {
        if (isset($response[self::CHECKOUT])) {
            $response[self::CHECKOUT] = (bool)$response[self::CHECKOUT];
        }

        return $response;
    }
}
