<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse\Button;

/**
 * Utility class for getting location destination from button action
 */
class LocationDetect
{
    private const LOCATION_PATTERN = '/(?<=document.location = \\")(.*)(?=\\";)/';

    public function getFromAction(string $action): ?string
    {
        preg_match(self::LOCATION_PATTERN, $action, $matches);

        return empty($matches)
            ? null
            : array_shift($matches);
    }
}
