<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse\Button;

use Amasty\AjaxCartHyva\Api\ResponseButtonInterface;
use Hyva\Theme\ViewModel\HeroiconsOutline;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\RequestInterface;

class ButtonTwo implements ResponseButtonInterface
{
    public const RESPONSE_NAME_PARAM = 'b2_name';
    public const RESPONSE_ACTION_PARAM = 'b2_action';
    public const SUBMIT_ACTION = 'amcart-dialog-submit';
    public const LOCATION_ACTION = 'amcart-change-location';

    /**
     * @var LocationDetect
     */
    private LocationDetect $locationDetect;

    /**
     * @var HeroiconsOutline
     */
    private HeroiconsOutline $heroicons;

    /**
     * @var RequestInterface
     */
    private RequestInterface $request;

    public function __construct(
        LocationDetect $locationDetect,
        HeroiconsOutline $heroicons,
        RequestInterface $request = null //TODO: move to not optional
    ) {
        $this->locationDetect = $locationDetect;
        $this->heroicons = $heroicons;
        $this->request = $request ?? ObjectManager::getInstance()->get(RequestInterface::class);
    }

    public function getResponseNameParam(): string
    {
        return self::RESPONSE_NAME_PARAM;
    }

    public function getResponseActionParam(): string
    {
        return self::RESPONSE_ACTION_PARAM;
    }

    public function convertName(string $name): string
    {
        return $this->heroicons->shoppingCartHtml('h-7 w-7 border-current inline mr-2', 25, 25)
            . $name;
    }

    public function convertAction(string $action): array
    {
        $location = $this->locationDetect->getFromAction($action);

        if ($location !== null) {
            $convertedAction['name'] =self::LOCATION_ACTION;
            $convertedAction['payload'] = $location;
        } else {
            $convertedAction['name'] = self::SUBMIT_ACTION;
            $convertedAction['payload'] = "amcart-add-to-{$this->request->getControllerName()}-action";
        }

        return $convertedAction;
    }
}
