<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse\Button;

use Amasty\AjaxCartHyva\Api\ResponseButtonInterface;

class ButtonOne implements ResponseButtonInterface
{
    public const RESPONSE_NAME_PARAM = 'b1_name';
    public const RESPONSE_ACTION_PARAM = 'b1_action';
    public const HIDE_ACTION = 'amcart-hide-popup';
    public const LOCATION_ACTION = 'amcart-change-location';

    /**
     * @var LocationDetect
     */
    private LocationDetect $locationDetect;

    public function __construct(
        LocationDetect $locationDetect
    ) {
        $this->locationDetect = $locationDetect;
    }

    public function getResponseNameParam(): string
    {
        return self::RESPONSE_NAME_PARAM;
    }

    public function getResponseActionParam(): string
    {
        return self::RESPONSE_ACTION_PARAM;
    }

    public function convertName(string $name): string
    {
        return $name;
    }

    public function convertAction(string $action): array
    {
        $location = $this->locationDetect->getFromAction($action);

        if ($location !== null) {
            $convertedAction['name'] = self::LOCATION_ACTION;
            $convertedAction['payload'] = $location;
        } else {
            $convertedAction['name'] = self::HIDE_ACTION;
        }

        return $convertedAction;
    }
}
