<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse\Button;

use Amasty\AjaxCartHyva\Api\ResponseButtonInterface;
use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;

class ButtonConverter implements ResponseConverterInterface
{
    /**
     * @var ResponseButtonInterface[] $buttons
     */
    private array $buttons;

    /**
     * @param ResponseButtonInterface[] $buttons
     */
    public function __construct(
        array $buttons
    ) {
        $this->buttons = $buttons;
    }

    public function convert(array $response): array
    {
        foreach ($this->buttons as $button) {
            $buttonName = $response[$button->getResponseNameParam()] ?? null;
            $buttonAction = $response[$button->getResponseActionParam()] ?? null;

            if ($buttonName !== null && $buttonAction !== null) {
                $convertedButton['name'] = $button->convertName($buttonName);
                $convertedButton['action'] = $button->convertAction($buttonAction);

                $response['buttons'][] = $convertedButton;

                unset($response[$button->getResponseNameParam()], $response[$button->getResponseActionParam()]);
            }
        }

        return $response;
    }
}
