<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter\CartAddResponse;

use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;

class AlignConverter implements ResponseConverterInterface
{
    private const CONFIRMATION_POPUP_ALIGN = 'align';

    /**
     * @var string[]
     */
    private array $alignMap;

    /**
     * @param string[] $alignMap
     */
    public function __construct(
        array $alignMap
    ) {
        $this->alignMap = $alignMap;
    }

    public function convert(array $response): array
    {
        if (isset($response[self::CONFIRMATION_POPUP_ALIGN])) {
            $responseAlign = $response[self::CONFIRMATION_POPUP_ALIGN];

            if ($this->containValidAlign($responseAlign)) {
                $response[self::CONFIRMATION_POPUP_ALIGN] = $this->resolveAlign($responseAlign);
            } else {
                unset($response[self::CONFIRMATION_POPUP_ALIGN]);
            }
        }

        return $response;
    }

    private function containValidAlign(string $responseAlign): bool
    {
        return is_numeric($responseAlign) && array_key_exists($responseAlign, $this->alignMap);
    }

    private function resolveAlign(string $responseAlign): string
    {
        return $this->alignMap[$responseAlign];
    }
}
