<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Ajax Cart Hyva Compatibility (System)
 */

namespace Amasty\AjaxCartHyva\Model\Adapter;

use Amasty\AjaxCartHyva\Api\ResponseAdapterInterface;
use Amasty\AjaxCartHyva\Api\ResponseConverterInterface;
use Amasty\Base\Model\Serializer;
use Magento\Framework\App\Response\HttpInterface;

class CartAddResponse implements ResponseAdapterInterface
{
    /**
     * @var Serializer
     */
    private Serializer $serializer;

    /**
     * @var ResponseConverterInterface[]
     */
    private array $responseConverters;

    /**
     * @param Serializer $serializer
     * @param ResponseConverterInterface[] $responseConverters
     */
    public function __construct(
        Serializer $serializer,
        array $responseConverters
    ) {
        $this->serializer = $serializer;
        $this->responseConverters = $responseConverters;
    }

    public function execute(HttpInterface $response): HttpInterface
    {
        $responseBody = $this->serializer->unserialize($response->getBody());

        if ($responseBody) {
            $responseBody = $this->transform($responseBody);
            $serializedResponseBody = $this->serializer->serialize($responseBody);

            if (!$serializedResponseBody) {
                throw new \LogicException('Unable to serialize Ajax Cart Add response');
            }

            $response->setBody($serializedResponseBody);
        }

        return $response;
    }

    private function transform(array $responseBody): array
    {
        foreach ($this->responseConverters as $converter) {
            if (!$converter instanceof ResponseConverterInterface) {
                throw new \InvalidArgumentException(
                    sprintf(
                        "Response Converter class %s must implement %s interface",
                        get_class($converter),
                        ResponseConverterInterface::class
                    )
                );
            }

            $responseBody = $converter->convert($responseBody);
        }

        return $responseBody;
    }
}
