define([
    'Magento_Ui/js/grid/tree-massactions',
    'mageUtils'
], function (MassActions, utils) {
    return MassActions.extend({
        defaultCallback: function (action, data) {
            var itemsType = data.excludeMode ? 'excluded' : 'selected',
                selections = {};

            selections[itemsType] = data[itemsType];

            if (!selections[itemsType].length) {
                selections[itemsType] = false;
            }

            _.extend(selections, data.params || {});

            utils.submit({
                url: action.url,
                data: selections
            });
        },
        getSelections: function () {
            var data = this._super();

            if (this.source.params.source_code) {
                data.params.source_code = this.source.params.source_code;
            }

            return data;
        }
    });
});
