define([
    'Magento_Ui/js/grid/columns/actions',
    'jquery',
    'uiRegistry'
], function (Actions, $, registry) {
    'use strict';

    return Actions.extend({
        defaults: {
            bodyTmpl: 'Amasty_AdvancedMSI/grid/column/actions',
            productId: '',
            productSku: '',
            productTypeId: ''
        },
        initObservable: function () {
            this._super().observe(['productId', 'productSku', 'productTypeId']);
            return this;
        },

        shouldShowButton: function (column) {
            return column().valid;
        },

        showPopup: function (column) {
            this.productId(column().entity_id);
            this.productSku(column().sku);
            this.productTypeId(column().type_id);
            var modal = registry.get('product_listing.product_listing.edit_sources_modal');
            modal.needReload = false;
            modal.setTitle(modal.options.title + ' for ' + column().name);
            var grid = registry.get('ammsi_inventory_source_listing.ammsi_inventory_source_listing_data_source');
            if (grid) {
                grid.params.random = Math.random();
                grid.reload();
            }
            modal.openModal();
        }
    });
});