define([
    'Magento_Ui/js/grid/editing/record',
    'underscore'
], function (Record, _) {
    return Record.extend({
        initObservable: function () {
            this._super();
            this.elems.subscribe(this.elementUpdate.bind(this), null, 'arrayChange');

            return this;
        },
        elementUpdate: function (elements) {
            _.each(elements, function (el) {
                if (el.value.index === 'quantity' && !el.value.source.data.valid) {
                    el.value.disabled(true);
                }
            });
        },
        buildField: function (column) {
            var result = this._super();
            if (column.index === 'notify_stock_qty') {
                result.service = {template: 'ui/form/element/helper/service'};
                result.component = 'Amasty_AdvancedMSI/js/grid/editing/element/abstract';
            }

            return result;
        },
        getData: function () {
            var data = this._super();

            if (_.isUndefined(data.source_code)) {
                data.source_code = this.sourceCode;
            }
            _.each(this.elems(), function (el) {
                switch (el.index) {
                    case 'notify_stock_qty':
                        if (el.disabled()) {
                            delete data.notify_stock_qty;
                        }
                        break;
                    case 'quantity':
                        if (!el.source.data.valid) {
                            el.disabled(true);
                        } else {
                            el.disabled(false);
                        }
                        break;
                }
            });

            return data;
        }
    });
});
