define([
    'Magento_Ui/js/form/components/insert-listing',
    'jquery',
    'underscore',
    'Magento_Ui/js/lib/spinner'
], function (InsertListing, $, _, loader) {
    return InsertListing.extend({
        defaults: {
            assignUrl: '',
            sourceProductGridProvider: '',
            externalProvider: '',
            modules: {
                sourceProductGridProvider: '${ $.sourceProductGridProvider }',
                externalProductGridProvider: '${ $.externalProvider }'
            }
        },
        hardReload: function () {
            this.render();
            if (!_.isUndefined(this.externalProductGridProvider())) {
                this.selections().deselectAll();
                this.externalProductGridProvider().params.rand = Math.random();
                this.externalProductGridProvider().reload();
            }
        },
        assignProductsToSource: function () {
            var postData = {};
            postData.namespace = this.externalProductGridProvider().params.namespace;
            if (this.selections().allSelected()) {
                postData.all = true;
                if (this.selections().excludeMode()) {
                    postData.excluded = 'false';
                } else {
                    postData.selected = this.selections().selected();
                }
                if (!_.isUndefined(this.externalProductGridProvider().params.filters)) {
                    postData.filters = this.externalProductGridProvider().params.filters;
                }
            } else {
                if (this.selections().excludeMode()) {
                    postData.excluded = this.selections().excluded();
                } else {
                    postData.selected = this.selections().selected();
                }
            }
            if (!_.isEmpty(postData)) {
                postData.source_code = this.sourceCode;
                loader.show();
                $.ajax({
                    url: this.assignUrl,
                    method: 'POST',
                    data: postData,
                    success: function () {
                        loader.hide();
                        this.sourceProductGridProvider().params.rand = Math.random();
                        this.sourceProductGridProvider().reload();
                    }.bind(this)
                });
            }
        }
    });
});
