<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Ui\Component\Listing\Column;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\InventoryCatalogApi\Api\DefaultStockProviderInterface;
use Magento\InventoryConfigurationApi\Api\GetStockItemConfigurationInterface;
use Magento\InventoryConfigurationApi\Model\IsSourceItemManagementAllowedForProductTypeInterface;
use Magento\Ui\Component\Listing\Columns\Column;

class Quantity extends Column
{
    /**
     * @var IsSourceItemManagementAllowedForProductTypeInterface
     */
    private $allowedForProductType;

    /**
     * @var GetStockItemConfigurationInterface
     */
    private $stockItemConfiguration;

    /**
     * @var DefaultStockProviderInterface
     */
    private $defaultStockProvider;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        IsSourceItemManagementAllowedForProductTypeInterface $allowedForProductType,
        GetStockItemConfigurationInterface $stockItemConfiguration,
        DefaultStockProviderInterface $defaultStockProvider,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->allowedForProductType = $allowedForProductType;
        $this->stockItemConfiguration = $stockItemConfiguration;
        $this->defaultStockProvider = $defaultStockProvider;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\InventoryConfigurationApi\Exception\SkuIsNotAssignedToStockException
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $item['valid'] = false;

                if (isset($item['sku'], $item['type_id'])) {
                    $item['valid'] = $this->isItemValid($item['sku'], $item['type_id']);
                }
            }
        }

        return $dataSource;
    }

    private function isItemValid($sku, $typeId): bool
    {
        $isValid = false;
        if ($this->allowedForProductType->execute($typeId) === true) {
            $isValid = $this->stockItemConfiguration->execute($sku, $this->defaultStockProvider->getId())
                ->isManageStock();
        }

        return $isValid;
    }
}
