<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\InventoryConfigurationApi\Model\IsSourceItemManagementAllowedForProductTypeInterface;
use Magento\Inventory\Model\ResourceModel\Source\Collection;
use Magento\Ui\Component\Listing\Columns\Column;

class EditSourcesAction extends Column
{
    /**
     * @var array
     */
    private $sourceCodes;

    /**
     * @var IsSourceItemManagementAllowedForProductTypeInterface
     */
    private $allowedForProductType;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        IsSourceItemManagementAllowedForProductTypeInterface $allowedForProductType,
        Collection $collection,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->sourceCodes = $collection->getColumnValues('source_code');
        $this->allowedForProductType = $allowedForProductType;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                if (isset($item['sku'])) {
                    $item['valid'] = false;
                    if (isset($item['type_id'])
                        && !empty($this->sourceCodes)
                        && $this->allowedForProductType->execute($item['type_id'])
                    ) {
                        $item['valid'] = true;
                    }
                }
            }
        }

        return $dataSource;
    }
}
