<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Setup\Declaration\Schema\Db\MySQL\DDL\Triggers;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\Declaration\Schema\Db\DDLTriggerInterface;
use Magento\Framework\Setup\Declaration\Schema\Dto\Table;
use Magento\Framework\Setup\Declaration\Schema\ElementHistory;

class MigrateDataFromAnotherTableIfExists implements DDLTriggerInterface
{
    public const MATCH_PATTERN = '/migrateDataFromAnotherTableIfExists\(([^\)]+)\)/';

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * Constructor.
     *
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * @inheritdoc
     */
    public function isApplicable(string $statement) : bool
    {
        return (bool) preg_match(self::MATCH_PATTERN, $statement);
    }

    /**
     * @inheritdoc
     */
    public function getCallback(ElementHistory $tableHistory) : callable
    {
        /** @var Table $table */
        $table = $tableHistory->getNew();
        preg_match(self::MATCH_PATTERN, $table->getOnCreate(), $matches);
        return function () use ($table, $matches) {
            $tableName = $table->getName();
            $oldTableName = $this->resourceConnection->getTableName($matches[1]);
            $adapter = $this->resourceConnection->getConnection($table->getResource());
            if ($adapter->isTableExists($oldTableName)) {
                $select = $adapter->select()->from($oldTableName);
                $adapter->query($adapter->insertFromSelect($select, $tableName));
            }
        };
    }
}
