<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Plugin\Shipping\Model\Shipping;

use Amasty\AdvancedMSI\Model\SourceSelection\CustomerAddressRegister;
use Magento\Quote\Model\Quote\Address\RateRequest;
use Magento\Shipping\Model\Shipping;

class DestinationAddress
{
    /**
     * @var CustomerAddressRegister
     */
    private $addressRegister;

    public function __construct(
        CustomerAddressRegister $addressRegister
    ) {
        $this->addressRegister = $addressRegister;
    }

    /**
     * It is needed to set address regardless of the configured algorithm in Amasty_AdvancedMSI.
     * Combined algorithm could be used in other extensions.
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeCollectRates(Shipping $subject, RateRequest $request)
    {
        $this->addressRegister->setDestinationAddressFromRequest($request->getData());
    }
}
