<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Plugin\InventorySourceSelectionApi\Model\SourceSelection;

use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionAlgorithmInterfaceFactory;

class GetSourceSelectionAlgorithmListPlugin
{
    /**
     * @var \Amasty\AdvancedMSI\Model\ConfigProvider
     */
    private $configProvider;

    /**
     * @var SourceSelectionAlgorithmInterfaceFactory
     */
    private $sourceSelectionAlgorithmFactory;

    public function __construct(
        SourceSelectionAlgorithmInterfaceFactory $sourceSelectionAlgorithmFactory,
        \Amasty\AdvancedMSI\Model\ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
        $this->sourceSelectionAlgorithmFactory = $sourceSelectionAlgorithmFactory;
    }

    /**
     * @param \Magento\InventorySourceSelectionApi\Model\GetSourceSelectionAlgorithmList $subject
     * @param array                                                                      $algorithmsList
     *
     * @return array
     */
    public function afterExecute(
        \Magento\InventorySourceSelectionApi\Model\GetSourceSelectionAlgorithmList $subject,
        array $algorithmsList
    ): array {
        if ($this->configProvider->isEnabled()) {
            $algorithmsList[] = $this->sourceSelectionAlgorithmFactory->create(
                [
                    'code'        => \Amasty\AdvancedMSI\Model\SourceSelection\Algorithms\StockBased::CODE,
                    'title'       => (string)__('Product Stock Availability by Amasty'),
                    'description' => (string)__(
                        'Algorithm which provides Source Selections based on ' .
                        'Product Stock Availability on Source by Amasty'
                    )
                ]
            );
            $algorithmsList[] = $this->sourceSelectionAlgorithmFactory->create(
                [
                    'code' => \Amasty\AdvancedMSI\Model\SourceSelection\Algorithms\Combined::CODE,
                    'title' => (string)__('Combined Source Selection Algorithm'),
                    'description' => (string)__(
                        'Algorithm which provides Source Selections based on ' .
                        'several selected alhgorithms'
                    )
                ]
            );
        }

        return $algorithmsList;
    }
}
