<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Plugin\InventorySourceSelectionApi\Api;

use Amasty\AdvancedMSI\Model\GetSourcesBySourceSelectionResult;
use Amasty\AdvancedMSI\Plugin\InventoryShippingAdminUi\Controller\Adminhtml\SourceSelection\ProcessAlgorithmPlugin;

class SourceSelectionServiceInterfacePlugin
{
    /**
     * @var GetSourcesBySourceSelectionResult
     */
    private $getSourcesBySourceSelectionResult;

    public function __construct(GetSourcesBySourceSelectionResult $getSourcesBySourceSelectionResult)
    {
        $this->getSourcesBySourceSelectionResult = $getSourcesBySourceSelectionResult;
    }

    /**
     * @param \Magento\InventorySourceSelectionApi\Api\SourceSelectionServiceInterface     $subject
     * @param \Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface $result
     *
     * @return \Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface
     */
    public function afterExecute(
        \Magento\InventorySourceSelectionApi\Api\SourceSelectionServiceInterface $subject,
        \Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface $result
    ) {
        if (ProcessAlgorithmPlugin::$CONTROLLER_OBJECT) {
            foreach ($this->getSourcesBySourceSelectionResult->execute($result) as $sourceCode) {
                ProcessAlgorithmPlugin::$CONTROLLER_OBJECT->getSourceName($sourceCode);
            }
        }

        return $result;
    }
}
