<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Plugin\InventoryReservations\Model;

use Amasty\AdvancedMSI\Model\ConfigProvider;

class AppendReservationsPlugin
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    /**
     * @param \Magento\InventoryReservations\Model\AppendReservations $subject
     * @param \Closure $proceed
     * @param array $reservations
     *
     * @return void
     */
    public function aroundExecute(
        \Magento\InventoryReservations\Model\AppendReservations $subject,
        \Closure $proceed,
        array $reservations
    ) {
        if (!$this->configProvider->isEnabled()
            || !$this->configProvider->getShippingCostOnSourceEnabled()
        ) {
            $proceed($reservations);
            return;
        }
    }
}
