<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Plugin\InventoryDistanceBasedSourceSelection\Model\DistanceProvider\GoogleMap;

use Magento\Framework\Exception\LocalizedException;
use Magento\InventoryDistanceBasedSourceSelection\Model\DistanceProvider;
use Magento\InventoryDistanceBasedSourceSelectionApi\Api\Data\LatLngInterface;

class GetDistancePlugin
{
    /**
     * @var DistanceProvider\Offline\GetDistanceFactory
     */
    private $offlineFactory;

    public function __construct(DistanceProvider\Offline\GetDistanceFactory $offlineFactory)
    {
        $this->offlineFactory = $offlineFactory;
    }

    /**
     * @param DistanceProvider\GoogleMap\GetDistance $subject
     * @param \Closure $proceed
     * @param LatLngInterface $source
     * @param LatLngInterface $destination
     * @return float
     */
    public function aroundExecute(
        DistanceProvider\GoogleMap\GetDistance $subject,
        \Closure $proceed,
        LatLngInterface $source,
        LatLngInterface $destination
    ): float {
        try {
            return $proceed($source, $destination);
        } catch (LocalizedException $e) {
            /**
             * In case of failure during a request to the Google Maps Distance Matrix Api witch returned ZERO_RESULTS
             * after trying to calculate the distance between two geo-points located on different continents
             * we should try to calculate it offline
             *
             * @var DistanceProvider\Offline\GetDistance $offlineDistanceProvider
             */
            $offlineDistanceProvider = $this->offlineFactory->create();

            return $offlineDistanceProvider->execute($source, $destination);
        }
    }
}
