<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Plugin\InventoryDistanceBasedSourceSelection;

use Amasty\AdvancedMSI\Model\ConfigProvider;
use Amasty\AdvancedMSI\Model\SourceSelection\CustomerAddressRegister;
use Magento\InventoryDistanceBasedSourceSelection\Model\Algorithms\DistanceBasedAlgorithm;
use Magento\InventorySourceSelection\Model\AddressFactory;
use Magento\InventorySourceSelectionApi\Api\Data\InventoryRequestInterface;

class DistanceBasedAlgorithmPlugin
{
    /**
     * @var CustomerAddressRegister
     */
    private $addressRegister;

    /**
     * @var AddressFactory
     */
    private $addressFactory;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        CustomerAddressRegister $addressRegister,
        AddressFactory $addressFactory,
        ConfigProvider $configProvider
    ) {
        $this->addressRegister = $addressRegister;
        $this->addressFactory = $addressFactory;
        $this->configProvider = $configProvider;
    }

    public function beforeExecute(
        DistanceBasedAlgorithm $subject,
        InventoryRequestInterface $inventoryRequest
    ) :void {
        if (!$this->configProvider->isEnabled()) {
            return;
        }
        $extension = $inventoryRequest->getExtensionAttributes();

        if (!$extension->getDestinationAddress()) {
            $destinationAddress = $this->addressFactory->create($this->addressRegister->getDestinationAddress());

            $extension->setDestinationAddress($destinationAddress);
            $inventoryRequest->setExtensionAttributes($extension);
        }
    }
}
