<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Observer;

use Amasty\AdvancedMSI\Model\ConfigProvider;
use Amasty\AdvancedMSI\Model\Repository\ReservedProductsRepository;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\InventoryApi\Api\GetSourceItemsBySkuInterface;
use Magento\InventoryApi\Api\SourceItemsSaveInterface;

class SaveSourceShippingCustomRates implements ObserverInterface
{
    /**
     * @var \Amasty\AdvancedMSI\Api\SourceCustomShippingRateRepositoryInterface
     */
    private $customShippingRateRepository;

    public function __construct(
        \Amasty\AdvancedMSI\Api\SourceCustomShippingRateRepositoryInterface $customShippingRateRepository
    ) {
        $this->customShippingRateRepository = $customShippingRateRepository;
    }

    public function execute(Observer $observer)
    {
        $request = $observer->getData('request');
        $source = $observer->getData('source');

        $formData = $request->getParam('general', []);
        $useDefault = $request->getParam('use_default', []);
        $defaultRates = [];
        if (!empty($useDefault['custom_shipping_rate'])) {
            $defaultRates = $useDefault['custom_shipping_rate'];
        }
        if (!empty($formData['custom_shipping_rate'])) {
            $rates = [];
            foreach ($formData['custom_shipping_rate'] as $shippingRateCode => $rate) {
                if (empty($defaultRates[$shippingRateCode])) {
                    $rates[] = $this->customShippingRateRepository->getEmptySourceCustomShippingRateModel()
                        ->setShippingRateCode($shippingRateCode)
                        ->setSourceCode($source->getSourceCode())
                        ->setShippingRate((float)$rate);
                }
            }

            $this->customShippingRateRepository->save($source->getSourceCode(), $rates);
        }
    }
}
