<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Observer;

use Amasty\AdvancedMSI\Api\SourceEmailRepositoryInterface;
use Amasty\AdvancedMSI\Plugin\InventorySourceUi\SourceDataProvider;
use Amasty\AdvancedMSI\Model\ResourceModel\SourceEmail;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;

class SaveSourceEmails implements ObserverInterface
{
    /**
     * @var \Amasty\AdvancedMSI\Api\SourceEmailRepositoryInterface
     */
    private $sourceEmailRepository;
    /**
     * @var SourceEmail
     */
    private $sourceEmailResource;

    public function __construct(
        SourceEmailRepositoryInterface $sourceEmailRepository,
        SourceEmail $sourceEmailResource
    ) {
        $this->sourceEmailRepository = $sourceEmailRepository;
        $this->sourceEmailResource = $sourceEmailResource;
    }

    public function execute(Observer $observer)
    {
        $request = $observer->getData('request');
        $source = $observer->getData('source');
        $formData = $request->getParam('general', []);

        if (isset($formData[SourceDataProvider::SHIPMENT_EMAILS])) {
            $orderEmails = array_filter(explode(',', $formData[SourceDataProvider::SHIPMENT_EMAILS]));
        }
        if (isset($formData[SourceDataProvider::LOW_STOCK_EMAILS])) {
            $lowStockEmails = array_filter(explode(',', $formData[SourceDataProvider::LOW_STOCK_EMAILS]));
        }

        $this->sourceEmailResource->deleteEmails(SourceDataProvider::SHIPMENT_EMAILS, $source->getSourceCode());
        if (!empty($orderEmails)) {
            $this->saveEmails($orderEmails, SourceDataProvider::SHIPMENT_EMAILS, $source->getSourceCode());
        }

        $this->sourceEmailResource->deleteEmails(SourceDataProvider::LOW_STOCK_EMAILS, $source->getSourceCode());
        if (!empty($lowStockEmails)) {
            $this->saveEmails($lowStockEmails, SourceDataProvider::LOW_STOCK_EMAILS, $source->getSourceCode());
        }
    }

    private function saveEmails($emails, $type, $source)
    {
        foreach ($emails as $email) {
            $email = $this->sourceEmailRepository->getEmptySourceEmailModel()
                ->setEmail($email)
                ->setEmailType($type)
                ->setSourceCode($source);

            $this->sourceEmailRepository->save($email);
        }
    }
}
