<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Observer;

use Amasty\AdvancedMSI\Model\ConfigProvider;
use Amasty\AdvancedMSI\Model\Repository\ReservedProductsRepository;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\InventoryApi\Api\GetSourceItemsBySkuInterface;
use Magento\InventoryApi\Api\SourceItemsSaveInterface;

class OrderCancel implements ObserverInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var ReservedProductsRepository
     */
    private $reservedProductsRepository;

    /**
     * @var GetSourceItemsBySkuInterface
     */
    private $sourceItemsBySku;

    /**
     * @var SourceItemsSaveInterface
     */
    private $sourceItemsSave;

    public function __construct(
        ConfigProvider $configProvider,
        ReservedProductsRepository $reservedProductsRepository,
        GetSourceItemsBySkuInterface $sourceItemsBySku,
        SourceItemsSaveInterface $sourceItemsSave
    ) {
        $this->configProvider = $configProvider;
        $this->reservedProductsRepository = $reservedProductsRepository;
        $this->sourceItemsBySku = $sourceItemsBySku;
        $this->sourceItemsSave = $sourceItemsSave;
    }

    public function execute(Observer $observer)
    {
        $orderId = $observer->getEvent()->getOrder()->getId();
        $reservedProducts = $this->reservedProductsRepository->getByOrderId($orderId);

        if (!$this->configProvider->isEnabled()
            || !$this->configProvider->getShippingCostOnSourceEnabled()
            || !$reservedProducts
        ) {
            return;
        }
        $itemsToRestore = [];

        foreach ($reservedProducts as $reservedProduct) {
            foreach ($this->sourceItemsBySku->execute($reservedProduct->getSku()) as $item) {
                if ($item->getSourceCode() === $reservedProduct->getSourceCode()) {
                    $item->setQuantity($item->getQuantity() + $reservedProduct->getQuantity());
                    array_push($itemsToRestore, $item);
                }
            }
        }
        $this->sourceItemsSave->execute($itemsToRestore);
        $this->reservedProductsRepository->deleteByOrderId($orderId);
    }
}
