<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\SourceSelection;

use Magento\InventorySourceSelectionApi\Api\Data\InventoryRequestInterface;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionItemInterfaceFactory;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterfaceFactory;
use Magento\InventorySourceDeductionApi\Model\GetSourceItemBySourceCodeAndSku;

class GetSourcesWithFullStockByRequest
{
    /**
     * @var GetSourceItemBySourceCodeAndSku
     */
    private $getSourceItemBySourceCodeAndSku;

    public function __construct(
        GetSourceItemBySourceCodeAndSku $getSourceItemBySourceCodeAndSku
    ) {
        $this->getSourceItemBySourceCodeAndSku = $getSourceItemBySourceCodeAndSku;
    }

    /**
     * Attempting to get Source for ship from one Source for whole inventoryRequest
     * return array of source codes which have full stock for all requested products
     * otherwise returns empty array
     *
     * @param array                     $sourceCodes
     * @param InventoryRequestInterface $inventoryRequest
     *
     * @return array
     */
    public function execute(array $sourceCodes, InventoryRequestInterface $inventoryRequest): array
    {
        if (empty($sourceCodes)) {
            return [];
        }
        $fullStockSourcesCodes = $sourceCodes;
        foreach ($fullStockSourcesCodes as $key => $sourceCode) {
            foreach ($inventoryRequest->getItems() as $item) {
                $itemSku = $item->getSku();
                $qtyToDeliver = $item->getQty();

                try {
                    $sourceItem = $this->getSourceItemBySourceCodeAndSku->execute($sourceCode, $itemSku);
                } catch (\Exception $e) {
                    $sourceItem = null;
                }
                if (null === $sourceItem || $qtyToDeliver > $sourceItem->getQuantity()) {
                    unset($fullStockSourcesCodes[$key]);
                    continue 2;
                }
            }
        }

        return $fullStockSourcesCodes;
    }
}
